	function [addercount, co, co0, termlog] = MATRIXSCSE2(vals, verbose)
	
	%	function [addercount, co, co0, termlog] = MATRIXSCSE(vals, verbose)
	%	implements a recursive Signed Common SubExpression algorithm for matrix
	%	multiplication.
	
	% 	Malcolm Macleod, 21 Feb 2004
	
	% 	inputs: vals - matrix of integer coefficients;
	% 	verbose, if 1 gives step by step printout; if 2 verifies result
	%	returns:
	% 	addercount: total addercost
	% 	co: final term array
	% 	co0: initial CSD array
	% 	termlog: an array which defines the terms used in the result
	
	con1 = 1000; % must be integer > max subexpressions required
	con2 = 10; % code used in overlap elimination; must be integer >2
	
	% con1p = con1+1; %code for 1x1
	% con1m = con1-1; %code for 1x-1
	con2i = 1/con2; % see above
	
	if nargin<2
	    verbose=0;
		%     if nargin<2
		%         mode=1; 
		%     end
	end

	% recurs = mode==1 | mode==4; %allow recursion
	
	[mrows, mcols] = size(vals);
	vals0 = vals; % save for end
	vals = round(vals(:)); % columns now one beneath another; ensure integer
	
	co = TWO_C_2_CSDC(vals,1); % each row is csd coeffs for one coeff
	if verbose==1 % printout initial term array
	    disp('initial CSD array, matrix columns one beneath another');	%===================	
	    disp(co);	%===================	
	end
	co0=co;
	[ncoe, wl] = size(co);
	
	% NOTES: col refers to matrix column and row to matrix row (both starting at 1), 
	% although these are stored in co0, co, in lexicographic order (column 1 then column 2
	% below it, etc.).  hofs (horizontal
	% offset) is the bit offset in coefficient (positive hofs => lower power of two,
	% since bits are stored MSB first). Composite terms (stored in termlog) are numbered
	% from 2 (1 is for original +-1 terms).  The first search is for subterms in
	% the same column (i.e. using single input data) - flagged by mcol2==0 - and
	% the second for subterms in different columns (creating outputs).  The
	% selected "best" term at each stage is the most-frequently occurring term, and
	% its subterms are replaced by "term" and 0 at the second position (offset
	% from the first by columns, if any, and "bitwise" by hofs).
	
	[X, Y]=meshgrid(1:wl,1:ncoe); % X and Y indexes for each bit-position in array
	term=1;
	termlog=0;
	coloffset = (0:mcols-1)*mrows; %offsets to same row (output) in all columns (inputs)
	while term>0
	    mLrr=0; % this stays zero if there are no "common terms"
	    maxcnt=0; % require >1 "common term" otherwise finish
	    % first search for multiple occurrences of any horizontal term in
	    % any single column (i.e. input multiplier block)
	    hofslist = 1:wl-1;
	    for col=1:mcols
	        rows = coloffset(col)+(1:mrows);
	        for hofs = hofslist
	            a1 = co(rows,1:wl-hofs); % "first" elements
	            a2 = co(rows,1+hofs:wl); % 2nd elements
	            sa1 = sign(a1).*(a2~=0); % sa1=0 if a1 or a2 zero, otherwise =sign(a1)
	            r = sa1.*(a1*con1+a2); % joint codes (first term positive)
	            if sum(sum(r~=0))>0
	                % next arrays used when clearing overlaps
	                i1a = X(1:mrows,1:wl-hofs); % top left X index
	                i2a = Y(1:mrows,1:wl-hofs); % top left Y index
	                
	                % now count occurrences of each code having this
	                % hofs-vofs geometry, after removing overlaps
	                rr = r(:);
	                rr=sort(rr(rr~=0)); % codes in sorted order
	                ind=1; Lrr = length(rr);
	                if Lrr>mLrr, mLrr=Lrr; end % flag that there are some common terms ##
						
						[nrr, ncr] = size(r);
						while ind<=Lrr
							cd = rr(ind); % next code value
							% clear any overlaps of this term
							r1 = r; % make copy of code array r
							i1=i1a(r==cd);
							i2=i2a(r==cd);
							for ii=1:length(i1)
								rro = i2(ii);
								if round(con2*mod(r1(rro,i1(ii)),1))==0 %provided this code start is not itself cleared
									rco = i1(ii)+hofs;
									if rro<=nrr & rco<=ncr
										r1(rro,rco) = ...
	                                    r1(rro,rco)+con2i; % flag "clear overlapping code start"
									end
								end
							end
						
							rr1 = r1(:); % arrange as a column, omitting "flagged cleared" ...
							rr1 = rr1(round(con2*mod(rr1,1))==0);
							
							% find the term that occurs most often, and save details
							z = length(find(rr1==cd));
							if z>maxcnt
								%                        if recurs | cd==con1p | cd==con1m
								%                            if Lrr>mLrr, mLrr=Lrr; end %flag that there are some common terms
	                            maxcnt=z; mcol1 = col; mcol2=0; %0 flags "within 1 column" term
	                            mhofs = hofs; mcode = cd;
								%                       end
							end
							ind=ind+z;
						end
					end
				end
			end
		
			% now search for repeated patterns of the form input(i)+-2^a input(j) in
			% the computation of a single output, for each output and each column-pair in turn.
			% These correspond to common subexpressions in output additions
			hofslist = 1-wl:wl-1;
			
			for col1 = 1:mcols-1 % the outer two loops
				rs1 = (1:mrows)+coloffset(col1);
				for col2=col1+1:mcols % search all column pairs.
					rs2 = (1:mrows)+coloffset(col2);
					for hofs = hofslist
						if hofs>=0
							ax = 1:wl-hofs;
						else
							ax = 1-hofs:wl;
						end
						% search all rows simultaneously
						a1 = co(rs1,ax); % "first" elements
						a2 = co(rs2,ax+hofs); % 2nd elements
						sa1 = sign(a1).*(a2~=0); % sa1=0 if a1 or a2 zero, otherwise =sign(a1)
						r = sa1.*(a1*con1+a2); % joint codes (first term positive)
						if sum(sum(r~=0))>0                    
							% now count occurrences of each code having this
							% hofs-vofs geometry (there can't be overlaps)
							rr = r(:);
							rr=sort(rr(rr~=0)); % codes in sorted order
							ind=1; Lrr = length(rr);
							if Lrr>mLrr, mLrr=Lrr; end % flag that there are some common terms ##
								
								while ind<=Lrr
									cd = rr(ind); % next code value
									% find the one that occurs most often, and save details
									z = length(find(rr==cd));
									if z>maxcnt
										maxcnt=z; mcol1 = col1; mhofs = hofs;
										mcol2 = col2; mcode = cd;
									end
									ind=ind+z;
								end % while
							end % if
						end % for
					end % for
				end % for
			
				% now substitute the new term code for the two original values in
				% "co" everywhere the term occurs
				if mLrr>0 & maxcnt>1
					term = term+1;
					termlog(term,1:4)=[ mcode mcol1 mhofs mcol2 ]; % save record
	                
					if mcol2==0
						% the maximum number of common terms were multiple occurrences of a horizontal term in
						% any single column (i.e. an input multiplier block)
						rows = coloffset(mcol1)+(1:mrows);
						% re-compute the code values for offsets mvofs and mhofs
						a1 = co(rows,1:wl-mhofs); % "first" elements
						a2 = co(rows,1+mhofs:wl); % 2nd elements
						sa1 = sign(a1).*(a2~=0); % sa1=0 if a1 or a2 zero, otherwise =sign(a1)
						r = sa1.*(a1*con1+a2); % joint codes (first term positive)
						
						%determine indexes of locations where code applies
						i1a = X(1:mrows,1:wl-mhofs);
						i2a = Y(1:mrows,1:wl-mhofs);
						i1=i1a(r==mcode);
						i2=i2a(r==mcode);
						[nrr, ncr] = size(r);            
						
						% and re-clear overlapping copies
						for ii=1:length(i1)
							rro = i2(ii);
							if round(con2*mod(r(rro,i1(ii)),1))==0 % provided this code start is not itself cleared
								rco = i1(ii)+mhofs;
								if rro<=nrr & rco<=ncr
									r(rro,rco) = ...
									r(rro,rco)+con2i; % flag "clear overlapping code start"
								end
							end
						end
					
						% remove the flagged terms
						r(round(con2*mod(r,1))==1) = 0;
						
						% overlaps have been cleared; now find occurrences of each code having this
						% hofs-vofs geometry
						i1=i1a(r==mcode);
						i2=i2a(r==mcode);
						
						% and overwrite with [ +/-term, 0]
						Li1 = length(i1);
						for ii=1:Li1
							z = i2(ii) + coloffset(mcol1); % row number in relevant column of array "co"
							i1ii = i1(ii);
							sgn = sign(co(z,i1ii));
							co(z,i1ii) = term.*sgn;
							co(z,i1ii+mhofs) = 0;
						end
					else
						rs1 = (1:mrows)+coloffset(mcol1);
						rs2 = (1:mrows)+coloffset(mcol2);
						if mhofs >= 0
							ax = 1:wl-mhofs;
						else
							ax = 1-mhofs:wl;
						end
						% re-compute the code values
						a1 = co(rs1,ax); % "first" elements
						a2 = co(rs2,ax+mhofs); % 2nd elements
						sa1 = sign(a1).*(a2~=0); % sa1=0 if a1 or a2 zero, otherwise =sign(a1)
						r = sa1.*(a1*con1+a2); % joint codes (first term positive)
						
						% determine indexes of locations where code applies
						i1a = X(1:mrows,1:wl-abs(mhofs));
						i2a = Y(1:mrows,1:wl-abs(mhofs));
						i1=i1a(r==mcode);
						i2=i2a(r==mcode);
						[nrr, ncr] = size(r);
						
						% and overwrite with [ +/-term, 0]
						Li1 = length(i1);
						for ii=1:Li1
							r1 = rs1(i2(ii));
							r2 = rs2(i2(ii));
							c1 = ax(i1(ii));
							sgn = sign(co(r1,c1));
							co(r1,c1) = term.*sgn;
							co(r2,c1+mhofs) = 0;
						end
					end
					if verbose == 1
						fprintf('maxcnt %i mcol1 %i mcol2 %i mhofs %i mcode %i\n',...
						maxcnt, mcol1, mcol2, mhofs, mcode)
						co
						pause
					end
				else
					term = -1; % no more terms - flag finished
				end
			end
		
			% compute total addercount
			% 1st term is number of composite terms (1 adder each)
			addercount = (max(max(abs(co)))-1);
			% 2nd term is number of final output adders
			addercount = addercount + sum(sum(co~=0));
			% but each output is made by summing its row over all cols, so each non-zero
			% output requires one adder fewer than was counted above. (so the following
			% test should subtract a number of adders equal to the number of non-zero
			% rows in the original matrix
			for ii = 1:mrows
				tst1 = sum(sum(abs(co(ii+coloffset,:))))>0;
				tst2 = sum(abs(vals0(ii,:)))>0;
				if tst1 ~= tst2
					%	        disp('tst1 ~= tst2')%===================
				end
				if tst1
					addercount = addercount - 1;
				end
			end
		
			if verbose ~= 2
				return
			end
			%verify result
			%	disp('verification');	%===================
			[Nterms,junk]=size(termlog);
			co1 = co;
			for term=Nterms:-1:2 %term 1 is the original +-1s and needs no processing
				mcode = termlog(term,1);
				t1 = round(mcode/con1);
				t2 = round(mcode-t1*con1);
				mcol1 = termlog(term,2);
				mhofs = termlog(term,3);
				mcol2 = termlog(term,4);
				for ro = 1:ncoe
					for h = 1:wl
						if abs(co1(ro,h)) == term
							if ceil(ro/mrows) ~= mcol1 %	make sure term appears in correct col
								disp('erk1');	%===================	
								keyboard 	
							end
							if mcol2 == 0 %	indicates 2nd col same as 1st
								mcol2 = mcol1;
							end
							if co1(ro+(mcol2-mcol1)*mrows,h+mhofs) ~= 0
								disp('erk2') %	check second place was correctly zeroed
								keyboard
							end
							%	replace term by its expansion
							sgn = sign(co1(ro,h));
							co1(ro+(mcol2-mcol1)*mrows,h+mhofs) = sgn*t2;
							co1(ro,h) = sgn*t1;
						end
					end
				end
			end
			if any(co1~=co0) %	make sure end result bitmap equals original
				disp('erk3');	%===================	
				keyboard
			end
			%	and convert all the way back from binary to input values
			p = 2..^(wl-1:-1:0)';
			v = co1*p;
			if any(v~=vals)
				disp('erk4');	%===================	
				keyboard
			end
			%	disp('completed');	%===================	
			
